// Localization
const translations = {
    'cs': {
        'Extension Options': 'Možnosti rozšíření',
        'Enable on localhost and 127.0.0.1': 'Povolit funkce na localhost a 127.0.0.1',
        'Use Localhost API for Verification': 'Použít Localhost API pro ověřování',
        'Language:': 'Jazyk:',
        'Settings saved.': 'Nastavení uloženo.'
    },
    'sk': {
        'Extension Options': 'Možnosti rozšírenia',
        'Enable on localhost and 127.0.0.1': 'Povoliť funkcie na localhost a 127.0.0.1',
        'Use Localhost API for Verification': 'Použiť Localhost API na overovanie',
        'Language:': 'Jazyk:',
        'Settings saved.': 'Nastavenia uložené.'
    }
    // English is default
};

function getLanguage() {
    // Detect browser language
    const lang = navigator.language || navigator.userLanguage;
    if (lang.startsWith('sk')) return 'sk';
    if (lang.startsWith('cs')) return 'cs';
    return 'en';
}

const lang = getLanguage();

function _t(str) {
    if (translations[lang] && translations[lang][str]) {
        return translations[lang][str];
    }
    return str; // fallback to key (English)
}

// Apply translations
function localizePage() {
    document.title = _t('Extension Options');
    const tTitle = document.getElementById('optionsTitle');
    if (tTitle) tTitle.textContent = _t('Extension Options');

    const tLabel = document.getElementById('labelLocalhost');
    if (tLabel) tLabel.textContent = _t('Enable on localhost and 127.0.0.1');

    const tLabelApi = document.getElementById('labelLocalhostApi');
    if (tLabelApi) tLabelApi.textContent = _t('Use Localhost API for Verification');

    const tLabelLang = document.getElementById('labelLanguage');
    if (tLabelLang) tLabelLang.textContent = _t('Language:');
}

// Saves options to chrome.storage
const saveOptions = () => {
    const enableLocalhost = document.getElementById('enableLocalhost').checked;
    const useLocalhostApi = document.getElementById('useLocalhostApi').checked;
    const preferredLanguage = document.getElementById('preferredLanguage').value;

    chrome.storage.sync.set(
        {
            enableLocalhost: enableLocalhost,
            useLocalhostApi: useLocalhostApi,
            preferredLanguage: preferredLanguage
        },
        () => {
            // Update status to let user know options were saved.
            const status = document.getElementById('status');
            status.textContent = _t('Settings saved.');
            setTimeout(() => {
                status.textContent = '';
            }, 2000);
        }
    );
};

// Restores select box and checkbox state using the preferences
// stored in chrome.storage.
const restoreOptions = () => {
    localizePage();
    chrome.storage.sync.get(
        {
            enableLocalhost: false,
            useLocalhostApi: false,
            preferredLanguage: 'en'
        }, // default value
        (items) => {
            document.getElementById('enableLocalhost').checked = items.enableLocalhost;
            document.getElementById('useLocalhostApi').checked = items.useLocalhostApi;
            document.getElementById('preferredLanguage').value = items.preferredLanguage;
        }
    );
};

document.addEventListener('DOMContentLoaded', restoreOptions);
document.getElementById('enableLocalhost').addEventListener('change', saveOptions);
document.getElementById('useLocalhostApi').addEventListener('change', saveOptions);
document.getElementById('preferredLanguage').addEventListener('change', saveOptions);
